<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class NodePoolDefaults extends \Google\Model
{
  protected $nodeConfigDefaultsType = NodeConfigDefaults::class;
  protected $nodeConfigDefaultsDataType = '';

  /**
   * Subset of NodeConfig message that has defaults.
   *
   * @param NodeConfigDefaults $nodeConfigDefaults
   */
  public function setNodeConfigDefaults(NodeConfigDefaults $nodeConfigDefaults)
  {
    $this->nodeConfigDefaults = $nodeConfigDefaults;
  }
  /**
   * @return NodeConfigDefaults
   */
  public function getNodeConfigDefaults()
  {
    return $this->nodeConfigDefaults;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NodePoolDefaults::class, 'Google_Service_Container_NodePoolDefaults');
