<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Games;

class SnapshotListResponse extends \Google\Collection
{
  protected $collection_key = 'items';
  protected $itemsType = Snapshot::class;
  protected $itemsDataType = 'array';
  /**
   * Uniquely identifies the type of this resource. Value is always the fixed
   * string `games#snapshotListResponse`.
   *
   * @var string
   */
  public $kind;
  /**
   * Token corresponding to the next page of results. If there are no more
   * results, the token is omitted.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * The snapshots.
   *
   * @param Snapshot[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return Snapshot[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * Uniquely identifies the type of this resource. Value is always the fixed
   * string `games#snapshotListResponse`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Token corresponding to the next page of results. If there are no more
   * results, the token is omitted.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SnapshotListResponse::class, 'Google_Service_Games_SnapshotListResponse');
