<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Sasportal;

class SasPortalAssignment extends \Google\Collection
{
  protected $collection_key = 'members';
  /**
   * The identities the role is assigned to. It can have the following values: *
   * `{user_email}`: An email address that represents a specific Google account.
   * For example: `alice@gmail.com`. * `{group_email}`: An email address that
   * represents a Google group. For example, `viewers@gmail.com`.
   *
   * @var string[]
   */
  public $members;
  /**
   * Required. Role that is assigned to `members`.
   *
   * @var string
   */
  public $role;

  /**
   * The identities the role is assigned to. It can have the following values: *
   * `{user_email}`: An email address that represents a specific Google account.
   * For example: `alice@gmail.com`. * `{group_email}`: An email address that
   * represents a Google group. For example, `viewers@gmail.com`.
   *
   * @param string[] $members
   */
  public function setMembers($members)
  {
    $this->members = $members;
  }
  /**
   * @return string[]
   */
  public function getMembers()
  {
    return $this->members;
  }
  /**
   * Required. Role that is assigned to `members`.
   *
   * @param string $role
   */
  public function setRole($role)
  {
    $this->role = $role;
  }
  /**
   * @return string
   */
  public function getRole()
  {
    return $this->role;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SasPortalAssignment::class, 'Google_Service_Sasportal_SasPortalAssignment');
